/*** 1.   ũƮ ***/

SELECT rownum AS seq, NEWID() AS main_code
	, DATEADD(MINUTE, rownum, '2020-01-01 00:00:00.000') AS date
INTO TB_Main04
FROM (SELECT ROW_NUMBER() OVER (ORDER BY a.number) AS rownum, a.number
	 FROM master..spt_values a 
	 JOIN master..spt_values b 
	 ON a.type = 'P' AND b.type = 'P' AND a.number <= 1000 AND b.number <= 1000
) a

SELECT main_code AS sub_code, CAST(seq%5326 AS INT) AS value 
INTO TB_Sub04
FROM TB_Main04

CREATE CLUSTERED INDEX CIDX_Main04 ON TB_Main04(date)
GO

/*** Լ  ***/
CREATE FUNCTION [dbo].[FN_Code]
(@a UNIQUEIDENTIFIER)
RETURNS UNIQUEIDENTIFIER
AS
BEGIN
	DECLARE @b UNIQUEIDENTIFIER
	SELECT @b = sub_code FROM TB_Sub04 WHERE sub_code = @a
	RETURN @b
END
GO


/*** 2. [AS-IS] SQL    ȹ ***/

SELECT *, [dbo].[FN_Code](Main_Code) AS f
FROM TB_Main04 A
WHERE A.date BETWEEN '2020-01-30 00:00:00.000' AND '2020-01-30 18:59:59.000'
GO


/*** 6. [TO-BE]   ***/
--ε  
CREATE INDEX NIDX01_Sub04 ON TB_Sub04(sub_code)
GO

--SQL 
SELECT *, [dbo].[FN_Code](Main_Code) AS f
FROM TB_Main04 A
WHERE A.date BETWEEN '2020-01-30 00:00:00.000' AND '2020-01-30 18:59:59.000'
GO